package model;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;

public class BookParser {
	public List<Book> getList(String urlString) throws IOException{
		List<Book> list=new ArrayList<>();
		JsonReader reader=null;
		HttpURLConnection con=null;
		URL url=new URL(urlString);
		con=(HttpURLConnection)url.openConnection();
		con.setRequestMethod("GET");
		InputStream is=con.getInputStream();
		InputStreamReader isr=new InputStreamReader(is,"UTF-8");
		reader=new JsonReader(isr);
		Gson gson=new Gson();
		JsonObject root=gson.fromJson(reader, JsonObject.class);
		JsonArray result=root.get("Items").getAsJsonArray();
		System.out.println(result.size());
		for(int i=0;i<result.size();i++) {
			Book book=new Book();
			JsonObject obj=result.get(i).getAsJsonObject().get("Item").getAsJsonObject();
			book.setTitle(obj.get("title").getAsString());
			book.setAuthor(obj.get("author").getAsString());
			book.setItemUrl(obj.get("itemUrl").getAsString());
			book.setMediumImageUrl(obj.get("mediumImageUrl").getAsString());
			list.add(book);


		}
		reader.close();
		con.disconnect();

		return list;
	}
}
