package controller;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.List;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import model.Book;
import model.BookParser;



/**
 * Servlet implementation class Main
 */
@WebServlet("/Main")
public class Main extends HttpServlet {
	private static final long serialVersionUID = 1L;

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		RequestDispatcher rd=request.getRequestDispatcher("/WEB-INF/view/main.jsp");
		rd.forward(request, response);

	}


	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		request.setCharacterEncoding("UTF-8");
		String keyword=request.getParameter("keyword");
		String urlString="https://app.rakuten.co.jp/services/api/BooksTotal/Search/20170404"
				+"?format=json&keyword="+URLEncoder.encode(keyword,"UTF-8")+"&booksGenreId=000&applicationId=1099249507950774425";
		//System.out.println(urlString);
		List<Book> list=new BookParser().getList(urlString);
		//System.out.println(list.get(0).getTitle());
		request.setAttribute("list",list);
		request.setAttribute("keyword", keyword);
		doGet(request,response);
	}

}

